/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.util.Trace;

class PrepareReply
implements RbfReply {
    private static final String TRACE_MASKT = "XRBFPMRT";
    private static final String TRACE_MASKF = "XRBFPMRF";
    private static final String TRACE_MASKD = "XRBFPMRD";
    private static final long serialVersionUID = -1004883639036709663L;
    private RbfRequestId requestId;
    private int status;
    private RbfErrorDetail errorDetail;
    static final int STATUS_ACCEPTED = 0;
    static final int STATUS_BUSY = 2;
    static final int STATUS_HANDLER_UNAVAILABLE = 4;
    static final int STATUS_INVALID_REQUEST = 6;
    static final int STATUS_INTERNAL_ERROR = 8;
    static final int STATUS_APPLICATION_ERROR = 12;

    PrepareReply(RbfRequestId requestId, int status) {
        this(requestId, status, null);
    }

    PrepareReply(RbfRequestId requestId, int status, RbfErrorDetail errorDetail) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        this.errorDetail = errorDetail;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    boolean isPreparing() {
        switch (this.status) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    boolean isBusy() {
        switch (this.status) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    boolean isError() {
        switch (this.status) {
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    int getErrorResultCode() {
        switch (this.status) {
            case 6: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 12: {
                return 12;
            }
        }
        return 8;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    RbfErrorDetail getErrorDetail() {
        return this.errorDetail;
    }

    public void process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        Trace.trace(TRACE_MASKT, "<- process()");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[PrepareReply: reqId=" + this.requestId + ", status=" + this.status + "]");
        return sb.toString();
    }
}

